<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json');

$persona_key = $_GET['persona'] ?? 'lily-seo';

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM ai_personas WHERE persona_key = ? AND is_active = TRUE");
    $stmt->execute([$persona_key]);
    $persona = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($persona) {
        echo json_encode([
            'success' => true,
            'persona' => $persona
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Persona not found'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>